package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IosManagedAppProtection;
import odata.msgraph.client.beta.entity.collection.request.ManagedMobileAppCollectionRequest;

@JsonIgnoreType
public class IosManagedAppProtectionRequest extends EntityRequest<IosManagedAppProtection> {

    public IosManagedAppProtectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(IosManagedAppProtection.class, contextPath, value, false);
    }

    public ManagedMobileAppRequest apps(String id) {
        return new ManagedMobileAppRequest(contextPath.addSegment("apps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedMobileAppCollectionRequest apps() {
        return new ManagedMobileAppCollectionRequest(
                        contextPath.addSegment("apps"), Optional.empty());
    }

    public ManagedAppPolicyDeploymentSummaryRequest deploymentSummary() {
        return new ManagedAppPolicyDeploymentSummaryRequest(contextPath.addSegment("deploymentSummary"), Optional.empty());
    }

}
