package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IosLobAppProvisioningConfiguration;
import odata.msgraph.client.beta.entity.IosLobAppProvisioningConfigurationAssignment;
import odata.msgraph.client.beta.entity.MobileAppProvisioningConfigGroupAssignment;
import odata.msgraph.client.beta.entity.collection.request.IosLobAppProvisioningConfigurationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppProvisioningConfigGroupAssignmentCollectionRequest;

@JsonIgnoreType
public class IosLobAppProvisioningConfigurationRequest extends EntityRequest<IosLobAppProvisioningConfiguration> {

    public IosLobAppProvisioningConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(IosLobAppProvisioningConfiguration.class, contextPath, value, false);
    }

    public IosLobAppProvisioningConfigurationAssignmentRequest assignments(String id) {
        return new IosLobAppProvisioningConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IosLobAppProvisioningConfigurationAssignmentCollectionRequest assignments() {
        return new IosLobAppProvisioningConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationDeviceStatusRequest deviceStatuses(String id) {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest deviceStatuses() {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"), Optional.empty());
    }

    public MobileAppProvisioningConfigGroupAssignmentRequest groupAssignments(String id) {
        return new MobileAppProvisioningConfigGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppProvisioningConfigGroupAssignmentCollectionRequest groupAssignments() {
        return new MobileAppProvisioningConfigGroupAssignmentCollectionRequest(
                        contextPath.addSegment("groupAssignments"), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationUserStatusRequest userStatuses(String id) {
        return new ManagedDeviceMobileAppConfigurationUserStatusRequest(contextPath.addSegment("userStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest userStatuses() {
        return new ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<MobileAppProvisioningConfigGroupAssignment> appProvisioningConfigurationGroupAssignments, List<IosLobAppProvisioningConfigurationAssignment> iOSLobAppProvisioningConfigAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("appProvisioningConfigurationGroupAssignments", "Collection(microsoft.graph.mobileAppProvisioningConfigGroupAssignment)", appProvisioningConfigurationGroupAssignments)
            .put("iOSLobAppProvisioningConfigAssignments", "Collection(microsoft.graph.iosLobAppProvisioningConfigurationAssignment)", iOSLobAppProvisioningConfigAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
