package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IosEnterpriseWiFiConfiguration;
import odata.msgraph.client.beta.entity.collection.request.IosTrustedRootCertificateCollectionRequest;

@JsonIgnoreType
public class IosEnterpriseWiFiConfigurationRequest extends EntityRequest<IosEnterpriseWiFiConfiguration> {

    public IosEnterpriseWiFiConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(IosEnterpriseWiFiConfiguration.class, contextPath, value, false);
    }

    public DeviceManagementDerivedCredentialSettingsRequest derivedCredentialSettings() {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentialSettings"), Optional.empty());
    }

    public IosCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"), Optional.empty());
    }

    public IosTrustedRootCertificateRequest rootCertificatesForServerValidation(String id) {
        return new IosTrustedRootCertificateRequest(contextPath.addSegment("rootCertificatesForServerValidation").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IosTrustedRootCertificateCollectionRequest rootCertificatesForServerValidation() {
        return new IosTrustedRootCertificateCollectionRequest(
                        contextPath.addSegment("rootCertificatesForServerValidation"), Optional.empty());
    }

}
