package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IosDerivedCredentialAuthenticationConfiguration;

@JsonIgnoreType
public class IosDerivedCredentialAuthenticationConfigurationRequest extends EntityRequest<IosDerivedCredentialAuthenticationConfiguration> {

    public IosDerivedCredentialAuthenticationConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(IosDerivedCredentialAuthenticationConfiguration.class, contextPath, value, false);
    }

    public DeviceManagementDerivedCredentialSettingsRequest derivedCredentialSettings() {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentialSettings"), Optional.empty());
    }

}
