package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.BufferDecryptionResult;
import odata.msgraph.client.beta.complex.BufferEncryptionResult;
import odata.msgraph.client.beta.complex.SigningResult;
import odata.msgraph.client.beta.complex.VerificationResult;
import odata.msgraph.client.beta.entity.InformationProtection;
import odata.msgraph.client.beta.entity.collection.request.DataLossPreventionPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SensitivityLabelCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ThreatAssessmentRequestCollectionRequest;

@JsonIgnoreType
public class InformationProtectionRequest extends EntityRequest<InformationProtection> {

    public InformationProtectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(InformationProtection.class, contextPath, value, false);
    }

    public BitlockerRequest bitlocker() {
        return new BitlockerRequest(contextPath.addSegment("bitlocker"), Optional.empty());
    }

    public DataLossPreventionPolicyRequest dataLossPreventionPolicies(String id) {
        return new DataLossPreventionPolicyRequest(contextPath.addSegment("dataLossPreventionPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DataLossPreventionPolicyCollectionRequest dataLossPreventionPolicies() {
        return new DataLossPreventionPolicyCollectionRequest(
                        contextPath.addSegment("dataLossPreventionPolicies"), Optional.empty());
    }

    public SensitivityLabelRequest sensitivityLabels(String id) {
        return new SensitivityLabelRequest(contextPath.addSegment("sensitivityLabels").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SensitivityLabelCollectionRequest sensitivityLabels() {
        return new SensitivityLabelCollectionRequest(
                        contextPath.addSegment("sensitivityLabels"), Optional.empty());
    }

    public SensitivityPolicySettingsRequest sensitivityPolicySettings() {
        return new SensitivityPolicySettingsRequest(contextPath.addSegment("sensitivityPolicySettings"), Optional.empty());
    }

    public InformationProtectionPolicyRequest policy() {
        return new InformationProtectionPolicyRequest(contextPath.addSegment("policy"), Optional.empty());
    }

    public ThreatAssessmentRequestRequest threatAssessmentRequests(String id) {
        return new ThreatAssessmentRequestRequest(contextPath.addSegment("threatAssessmentRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ThreatAssessmentRequestCollectionRequest threatAssessmentRequests() {
        return new ThreatAssessmentRequestCollectionRequest(
                        contextPath.addSegment("threatAssessmentRequests"), Optional.empty());
    }

    @Action(name = "decryptBuffer")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BufferDecryptionResult> decryptBuffer(byte[] encryptedBuffer, byte[] publishingLicense) {
        Preconditions.checkNotNull(encryptedBuffer, "encryptedBuffer cannot be null");
        Preconditions.checkNotNull(publishingLicense, "publishingLicense cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("encryptedBuffer", "Edm.Binary", encryptedBuffer)
            .put("publishingLicense", "Edm.Binary", publishingLicense)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BufferDecryptionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.decryptBuffer"), BufferDecryptionResult.class, _parameters);
    }

    @Action(name = "encryptBuffer")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BufferEncryptionResult> encryptBuffer(byte[] buffer, UUID labelId) {
        Preconditions.checkNotNull(buffer, "buffer cannot be null");
        Preconditions.checkNotNull(labelId, "labelId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("buffer", "Edm.Binary", buffer)
            .put("labelId", "Edm.Guid", labelId)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BufferEncryptionResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.encryptBuffer"), BufferEncryptionResult.class, _parameters);
    }

    @Action(name = "signDigest")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<SigningResult> signDigest(byte[] digest) {
        Preconditions.checkNotNull(digest, "digest cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("digest", "Edm.Binary", digest)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<SigningResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.signDigest"), SigningResult.class, _parameters);
    }

    @Action(name = "verifySignature")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<VerificationResult> verifySignature(byte[] digest, byte[] signature, String signingKeyId) {
        Preconditions.checkNotNull(digest, "digest cannot be null");
        Preconditions.checkNotNull(signature, "signature cannot be null");
        Preconditions.checkNotNull(signingKeyId, "signingKeyId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("digest", "Edm.Binary", digest)
            .put("signature", "Edm.Binary", signature)
            .put("signingKeyId", "Edm.String", Checks.checkIsAscii(signingKeyId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<VerificationResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.verifySignature"), VerificationResult.class, _parameters);
    }

}
