package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.InformationProtectionPolicy;
import odata.msgraph.client.beta.entity.collection.request.InformationProtectionLabelCollectionRequest;

@JsonIgnoreType
public class InformationProtectionPolicyRequest extends EntityRequest<InformationProtectionPolicy> {

    public InformationProtectionPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(InformationProtectionPolicy.class, contextPath, value, false);
    }

    public InformationProtectionLabelRequest labels(String id) {
        return new InformationProtectionLabelRequest(contextPath.addSegment("labels").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public InformationProtectionLabelCollectionRequest labels() {
        return new InformationProtectionLabelCollectionRequest(
                        contextPath.addSegment("labels"), Optional.empty());
    }

}
