package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.InboundSharedUserProfile;

@JsonIgnoreType
public class InboundSharedUserProfileRequest extends EntityRequest<InboundSharedUserProfile> {

    public InboundSharedUserProfileRequest(ContextPath contextPath, Optional<Object> value) {
        super(InboundSharedUserProfile.class, contextPath, value, false);
    }

    @Action(name = "exportPersonalData")
    @JsonIgnore
    public ActionRequestNoReturn exportPersonalData(String storageLocation) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("storageLocation", "Edm.String", Checks.checkIsAscii(storageLocation))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportPersonalData"), _parameters);
    }

    @Action(name = "removePersonalData")
    @JsonIgnore
    public ActionRequestNoReturn removePersonalData() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removePersonalData"), _parameters);
    }

}
