package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IdentityGovernance;

@JsonIgnoreType
public class IdentityGovernanceRequest extends EntityRequest<IdentityGovernance> {

    public IdentityGovernanceRequest(ContextPath contextPath, Optional<Object> value) {
        super(IdentityGovernance.class, contextPath, value, false);
    }

    public AccessReviewSetRequest accessReviews() {
        return new AccessReviewSetRequest(contextPath.addSegment("accessReviews"), Optional.empty());
    }

    public AppConsentApprovalRouteRequest appConsent() {
        return new AppConsentApprovalRouteRequest(contextPath.addSegment("appConsent"), Optional.empty());
    }

    public TermsOfUseContainerRequest termsOfUse() {
        return new TermsOfUseContainerRequest(contextPath.addSegment("termsOfUse"), Optional.empty());
    }

    public EntitlementManagementRequest entitlementManagement() {
        return new EntitlementManagementRequest(contextPath.addSegment("entitlementManagement"), Optional.empty());
    }

}
