package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IdentityApiConnector;

@JsonIgnoreType
public class IdentityApiConnectorRequest extends EntityRequest<IdentityApiConnector> {

    public IdentityApiConnectorRequest(ContextPath contextPath, Optional<Object> value) {
        super(IdentityApiConnector.class, contextPath, value, false);
    }

    @Action(name = "uploadClientCertificate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<IdentityApiConnector> uploadClientCertificate(String pkcs12Value, String password) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("pkcs12Value", "Edm.String", Checks.checkIsAscii(pkcs12Value))
            .put("password", "Edm.String", Checks.checkIsAscii(password))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<IdentityApiConnector>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadClientCertificate"), IdentityApiConnector.class, _parameters);
    }

}
