package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupPolicyMigrationReport;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicySettingMappingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnsupportedGroupPolicyExtensionCollectionRequest;

@JsonIgnoreType
public class GroupPolicyMigrationReportRequest extends EntityRequest<GroupPolicyMigrationReport> {

    public GroupPolicyMigrationReportRequest(ContextPath contextPath, Optional<Object> value) {
        super(GroupPolicyMigrationReport.class, contextPath, value, false);
    }

    public GroupPolicySettingMappingRequest groupPolicySettingMappings(String id) {
        return new GroupPolicySettingMappingRequest(contextPath.addSegment("groupPolicySettingMappings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicySettingMappingCollectionRequest groupPolicySettingMappings() {
        return new GroupPolicySettingMappingCollectionRequest(
                        contextPath.addSegment("groupPolicySettingMappings"), Optional.empty());
    }

    public UnsupportedGroupPolicyExtensionRequest unsupportedGroupPolicyExtensions(String id) {
        return new UnsupportedGroupPolicyExtensionRequest(contextPath.addSegment("unsupportedGroupPolicyExtensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnsupportedGroupPolicyExtensionCollectionRequest unsupportedGroupPolicyExtensions() {
        return new UnsupportedGroupPolicyExtensionCollectionRequest(
                        contextPath.addSegment("unsupportedGroupPolicyExtensions"), Optional.empty());
    }

}
