package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GovernanceRoleSetting;

@JsonIgnoreType
public class GovernanceRoleSettingRequest extends EntityRequest<GovernanceRoleSetting> {

    public GovernanceRoleSettingRequest(ContextPath contextPath, Optional<Object> value) {
        super(GovernanceRoleSetting.class, contextPath, value, false);
    }

    public GovernanceResourceRequest resource() {
        return new GovernanceResourceRequest(contextPath.addSegment("resource"), Optional.empty());
    }

    public GovernanceRoleDefinitionRequest roleDefinition() {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("roleDefinition"), Optional.empty());
    }

}
