package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GovernanceResource;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleAssignmentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleSettingCollectionRequest;

@JsonIgnoreType
public class GovernanceResourceRequest extends EntityRequest<GovernanceResource> {

    public GovernanceResourceRequest(ContextPath contextPath, Optional<Object> value) {
        super(GovernanceResource.class, contextPath, value, false);
    }

    public GovernanceResourceRequest parent() {
        return new GovernanceResourceRequest(contextPath.addSegment("parent"), Optional.empty());
    }

    public GovernanceRoleAssignmentRequestRequest roleAssignmentRequests(String id) {
        return new GovernanceRoleAssignmentRequestRequest(contextPath.addSegment("roleAssignmentRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceRoleAssignmentRequestCollectionRequest roleAssignmentRequests() {
        return new GovernanceRoleAssignmentRequestCollectionRequest(
                        contextPath.addSegment("roleAssignmentRequests"), Optional.empty());
    }

    public GovernanceRoleAssignmentRequest roleAssignments(String id) {
        return new GovernanceRoleAssignmentRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceRoleAssignmentCollectionRequest roleAssignments() {
        return new GovernanceRoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"), Optional.empty());
    }

    public GovernanceRoleDefinitionRequest roleDefinitions(String id) {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("roleDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceRoleDefinitionCollectionRequest roleDefinitions() {
        return new GovernanceRoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"), Optional.empty());
    }

    public GovernanceRoleSettingRequest roleSettings(String id) {
        return new GovernanceRoleSettingRequest(contextPath.addSegment("roleSettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernanceRoleSettingCollectionRequest roleSettings() {
        return new GovernanceRoleSettingCollectionRequest(
                        contextPath.addSegment("roleSettings"), Optional.empty());
    }

}
