package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.External;
import odata.msgraph.client.beta.entity.collection.request.ExternalConnectionCollectionRequest;

@JsonIgnoreType
public class ExternalRequest extends EntityRequest<External> {

    public ExternalRequest(ContextPath contextPath, Optional<Object> value) {
        super(External.class, contextPath, value, false);
    }

    public ExternalConnectionRequest connections(String id) {
        return new ExternalConnectionRequest(contextPath.addSegment("connections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExternalConnectionCollectionRequest connections() {
        return new ExternalConnectionCollectionRequest(
                        contextPath.addSegment("connections"), Optional.empty());
    }

}
