package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ExternalConnection;
import odata.msgraph.client.beta.entity.collection.request.ConnectionOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExternalGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExternalItemCollectionRequest;

@JsonIgnoreType
public class ExternalConnectionRequest extends EntityRequest<ExternalConnection> {

    public ExternalConnectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(ExternalConnection.class, contextPath, value, false);
    }

    public ExternalGroupRequest groups(String id) {
        return new ExternalGroupRequest(contextPath.addSegment("groups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExternalGroupCollectionRequest groups() {
        return new ExternalGroupCollectionRequest(
                        contextPath.addSegment("groups"), Optional.empty());
    }

    public ExternalItemRequest items(String id) {
        return new ExternalItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExternalItemCollectionRequest items() {
        return new ExternalItemCollectionRequest(
                        contextPath.addSegment("items"), Optional.empty());
    }

    public ConnectionOperationRequest operations(String id) {
        return new ConnectionOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConnectionOperationCollectionRequest operations() {
        return new ConnectionOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

    public SchemaRequest schema() {
        return new SchemaRequest(contextPath.addSegment("schema"), Optional.empty());
    }

}
