package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Employee;
import odata.msgraph.client.beta.entity.collection.request.PictureCollectionRequest;

@JsonIgnoreType
public class EmployeeRequest extends EntityRequest<Employee> {

    public EmployeeRequest(ContextPath contextPath, Optional<Object> value) {
        super(Employee.class, contextPath, value, false);
    }

    public PictureRequest picture(String id) {
        return new PictureRequest(contextPath.addSegment("picture").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PictureCollectionRequest picture() {
        return new PictureCollectionRequest(
                        contextPath.addSegment("picture"), Optional.empty());
    }

}
