package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EducationUser;
import odata.msgraph.client.beta.entity.collection.request.EducationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationClassCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationRubricCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSchoolCollectionRequest;

@JsonIgnoreType
public class EducationUserRequest extends EntityRequest<EducationUser> {

    public EducationUserRequest(ContextPath contextPath, Optional<Object> value) {
        super(EducationUser.class, contextPath, value, false);
    }

    public EducationAssignmentRequest assignments(String id) {
        return new EducationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationAssignmentCollectionRequest assignments() {
        return new EducationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public EducationRubricRequest rubrics(String id) {
        return new EducationRubricRequest(contextPath.addSegment("rubrics").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationRubricCollectionRequest rubrics() {
        return new EducationRubricCollectionRequest(
                        contextPath.addSegment("rubrics"), Optional.empty());
    }

    public EducationClassRequest classes(String id) {
        return new EducationClassRequest(contextPath.addSegment("classes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationClassCollectionRequest classes() {
        return new EducationClassCollectionRequest(
                        contextPath.addSegment("classes"), Optional.empty());
    }

    public EducationSchoolRequest schools(String id) {
        return new EducationSchoolRequest(contextPath.addSegment("schools").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationSchoolCollectionRequest schools() {
        return new EducationSchoolCollectionRequest(
                        contextPath.addSegment("schools"), Optional.empty());
    }

    public EducationClassRequest taughtClasses(String id) {
        return new EducationClassRequest(contextPath.addSegment("taughtClasses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationClassCollectionRequest taughtClasses() {
        return new EducationClassCollectionRequest(
                        contextPath.addSegment("taughtClasses"), Optional.empty());
    }

    public UserRequest user() {
        return new UserRequest(contextPath.addSegment("user"), Optional.empty());
    }

}
