package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EducationSchool;
import odata.msgraph.client.beta.entity.collection.request.EducationClassCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationUserCollectionRequest;

@JsonIgnoreType
public class EducationSchoolRequest extends EntityRequest<EducationSchool> {

    public EducationSchoolRequest(ContextPath contextPath, Optional<Object> value) {
        super(EducationSchool.class, contextPath, value, false);
    }

    public AdministrativeUnitRequest administrativeUnit() {
        return new AdministrativeUnitRequest(contextPath.addSegment("administrativeUnit"), Optional.empty());
    }

    public EducationClassRequest classes(String id) {
        return new EducationClassRequest(contextPath.addSegment("classes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationClassCollectionRequest classes() {
        return new EducationClassCollectionRequest(
                        contextPath.addSegment("classes"), Optional.empty());
    }

    public EducationUserRequest users(String id) {
        return new EducationUserRequest(contextPath.addSegment("users").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationUserCollectionRequest users() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("users"), Optional.empty());
    }

}
