package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EducationRoot;
import odata.msgraph.client.beta.entity.collection.request.EducationClassCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSchoolCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSynchronizationProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationUserCollectionRequest;

@JsonIgnoreType
public class EducationRootRequest extends EntityRequest<EducationRoot> {

    public EducationRootRequest(ContextPath contextPath, Optional<Object> value) {
        super(EducationRoot.class, contextPath, value, false);
    }

    public EducationSynchronizationProfileRequest synchronizationProfiles(String id) {
        return new EducationSynchronizationProfileRequest(contextPath.addSegment("synchronizationProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationSynchronizationProfileCollectionRequest synchronizationProfiles() {
        return new EducationSynchronizationProfileCollectionRequest(
                        contextPath.addSegment("synchronizationProfiles"), Optional.empty());
    }

    public EducationClassRequest classes(String id) {
        return new EducationClassRequest(contextPath.addSegment("classes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationClassCollectionRequest classes() {
        return new EducationClassCollectionRequest(
                        contextPath.addSegment("classes"), Optional.empty());
    }

    public EducationUserRequest me() {
        return new EducationUserRequest(contextPath.addSegment("me"), Optional.empty());
    }

    public EducationSchoolRequest schools(String id) {
        return new EducationSchoolRequest(contextPath.addSegment("schools").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationSchoolCollectionRequest schools() {
        return new EducationSchoolCollectionRequest(
                        contextPath.addSegment("schools"), Optional.empty());
    }

    public EducationUserRequest users(String id) {
        return new EducationUserRequest(contextPath.addSegment("users").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationUserCollectionRequest users() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("users"), Optional.empty());
    }

}
