package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EducationAssignment;
import odata.msgraph.client.beta.entity.collection.request.EducationAssignmentResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSubmissionCollectionRequest;

@JsonIgnoreType
public class EducationAssignmentRequest extends EntityRequest<EducationAssignment> {

    public EducationAssignmentRequest(ContextPath contextPath, Optional<Object> value) {
        super(EducationAssignment.class, contextPath, value, false);
    }

    public EducationCategoryRequest categories(String id) {
        return new EducationCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationCategoryCollectionRequest categories() {
        return new EducationCategoryCollectionRequest(
                        contextPath.addSegment("categories"), Optional.empty());
    }

    public EducationAssignmentResourceRequest resources(String id) {
        return new EducationAssignmentResourceRequest(contextPath.addSegment("resources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationAssignmentResourceCollectionRequest resources() {
        return new EducationAssignmentResourceCollectionRequest(
                        contextPath.addSegment("resources"), Optional.empty());
    }

    public EducationRubricRequest rubric() {
        return new EducationRubricRequest(contextPath.addSegment("rubric"), Optional.empty());
    }

    public EducationSubmissionRequest submissions(String id) {
        return new EducationSubmissionRequest(contextPath.addSegment("submissions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationSubmissionCollectionRequest submissions() {
        return new EducationSubmissionCollectionRequest(
                        contextPath.addSegment("submissions"), Optional.empty());
    }

    @Action(name = "publish")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationAssignment> publish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.publish"), EducationAssignment.class, _parameters);
    }

    @Action(name = "setUpResourcesFolder")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationAssignment> setUpResourcesFolder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setUpResourcesFolder"), EducationAssignment.class, _parameters);
    }

}
