package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Domain;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DomainDnsRecordCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.InternalDomainFederationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SharedEmailDomainInvitationCollectionRequest;

@JsonIgnoreType
public class DomainRequest extends EntityRequest<Domain> {

    public DomainRequest(ContextPath contextPath, Optional<Object> value) {
        super(Domain.class, contextPath, value, false);
    }

    public DirectoryObjectRequest domainNameReferences(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("domainNameReferences").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest domainNameReferences() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("domainNameReferences"), Optional.empty());
    }

    public InternalDomainFederationRequest federationConfiguration(String id) {
        return new InternalDomainFederationRequest(contextPath.addSegment("federationConfiguration").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public InternalDomainFederationCollectionRequest federationConfiguration() {
        return new InternalDomainFederationCollectionRequest(
                        contextPath.addSegment("federationConfiguration"), Optional.empty());
    }

    public DomainDnsRecordRequest serviceConfigurationRecords(String id) {
        return new DomainDnsRecordRequest(contextPath.addSegment("serviceConfigurationRecords").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DomainDnsRecordCollectionRequest serviceConfigurationRecords() {
        return new DomainDnsRecordCollectionRequest(
                        contextPath.addSegment("serviceConfigurationRecords"), Optional.empty());
    }

    public SharedEmailDomainInvitationRequest sharedEmailDomainInvitations(String id) {
        return new SharedEmailDomainInvitationRequest(contextPath.addSegment("sharedEmailDomainInvitations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SharedEmailDomainInvitationCollectionRequest sharedEmailDomainInvitations() {
        return new SharedEmailDomainInvitationCollectionRequest(
                        contextPath.addSegment("sharedEmailDomainInvitations"), Optional.empty());
    }

    public DomainDnsRecordRequest verificationDnsRecords(String id) {
        return new DomainDnsRecordRequest(contextPath.addSegment("verificationDnsRecords").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DomainDnsRecordCollectionRequest verificationDnsRecords() {
        return new DomainDnsRecordCollectionRequest(
                        contextPath.addSegment("verificationDnsRecords"), Optional.empty());
    }

    @Action(name = "forceDelete")
    @JsonIgnore
    public ActionRequestNoReturn forceDelete(Boolean disableUserAccounts) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("disableUserAccounts", "Edm.Boolean", disableUserAccounts)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.forceDelete"), _parameters);
    }

    @Action(name = "verify")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Domain> verify() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Domain>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.verify"), Domain.class, _parameters);
    }

}
