package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Document;
import odata.msgraph.client.beta.entity.collection.request.DocumentCommentCollectionRequest;

@JsonIgnoreType
public class DocumentRequest extends EntityRequest<Document> {

    public DocumentRequest(ContextPath contextPath, Optional<Object> value) {
        super(Document.class, contextPath, value, false);
    }

    public DocumentCommentRequest comments(String id) {
        return new DocumentCommentRequest(contextPath.addSegment("comments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DocumentCommentCollectionRequest comments() {
        return new DocumentCommentCollectionRequest(
                        contextPath.addSegment("comments"), Optional.empty());
    }

}
