package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DocumentComment;
import odata.msgraph.client.beta.entity.collection.request.DocumentCommentReplyCollectionRequest;

@JsonIgnoreType
public class DocumentCommentRequest extends EntityRequest<DocumentComment> {

    public DocumentCommentRequest(ContextPath contextPath, Optional<Object> value) {
        super(DocumentComment.class, contextPath, value, false);
    }

    public DocumentCommentReplyRequest replies(String id) {
        return new DocumentCommentReplyRequest(contextPath.addSegment("replies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DocumentCommentReplyCollectionRequest replies() {
        return new DocumentCommentReplyCollectionRequest(
                        contextPath.addSegment("replies"), Optional.empty());
    }

}
