package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Directory;
import odata.msgraph.client.beta.entity.collection.request.AdministrativeUnitCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AttributeSetCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CustomSecurityAttributeDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.FeatureRolloutPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityProviderBaseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.InboundSharedUserProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OutboundSharedUserProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RecommendationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RecommendationResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SharedEmailDomainCollectionRequest;

@JsonIgnoreType
public class DirectoryRequest extends EntityRequest<Directory> {

    public DirectoryRequest(ContextPath contextPath, Optional<Object> value) {
        super(Directory.class, contextPath, value, false);
    }

    public RecommendationResourceRequest impactedResources(String id) {
        return new RecommendationResourceRequest(contextPath.addSegment("impactedResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RecommendationResourceCollectionRequest impactedResources() {
        return new RecommendationResourceCollectionRequest(
                        contextPath.addSegment("impactedResources"), Optional.empty());
    }

    public RecommendationRequest recommendations(String id) {
        return new RecommendationRequest(contextPath.addSegment("recommendations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RecommendationCollectionRequest recommendations() {
        return new RecommendationCollectionRequest(
                        contextPath.addSegment("recommendations"), Optional.empty());
    }

    public AdministrativeUnitRequest administrativeUnits(String id) {
        return new AdministrativeUnitRequest(contextPath.addSegment("administrativeUnits").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AdministrativeUnitCollectionRequest administrativeUnits() {
        return new AdministrativeUnitCollectionRequest(
                        contextPath.addSegment("administrativeUnits"), Optional.empty());
    }

    public AttributeSetRequest attributeSets(String id) {
        return new AttributeSetRequest(contextPath.addSegment("attributeSets").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AttributeSetCollectionRequest attributeSets() {
        return new AttributeSetCollectionRequest(
                        contextPath.addSegment("attributeSets"), Optional.empty());
    }

    public CustomSecurityAttributeDefinitionRequest customSecurityAttributeDefinitions(String id) {
        return new CustomSecurityAttributeDefinitionRequest(contextPath.addSegment("customSecurityAttributeDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CustomSecurityAttributeDefinitionCollectionRequest customSecurityAttributeDefinitions() {
        return new CustomSecurityAttributeDefinitionCollectionRequest(
                        contextPath.addSegment("customSecurityAttributeDefinitions"), Optional.empty());
    }

    public DirectoryObjectRequest deletedItems(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("deletedItems").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest deletedItems() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("deletedItems"), Optional.empty());
    }

    public IdentityProviderBaseRequest federationConfigurations(String id) {
        return new IdentityProviderBaseRequest(contextPath.addSegment("federationConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityProviderBaseCollectionRequest federationConfigurations() {
        return new IdentityProviderBaseCollectionRequest(
                        contextPath.addSegment("federationConfigurations"), Optional.empty());
    }

    public InboundSharedUserProfileRequest inboundSharedUserProfiles(String id) {
        return new InboundSharedUserProfileRequest(contextPath.addSegment("inboundSharedUserProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public InboundSharedUserProfileCollectionRequest inboundSharedUserProfiles() {
        return new InboundSharedUserProfileCollectionRequest(
                        contextPath.addSegment("inboundSharedUserProfiles"), Optional.empty());
    }

    public OutboundSharedUserProfileRequest outboundSharedUserProfiles(String id) {
        return new OutboundSharedUserProfileRequest(contextPath.addSegment("outboundSharedUserProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OutboundSharedUserProfileCollectionRequest outboundSharedUserProfiles() {
        return new OutboundSharedUserProfileCollectionRequest(
                        contextPath.addSegment("outboundSharedUserProfiles"), Optional.empty());
    }

    public SharedEmailDomainRequest sharedEmailDomains(String id) {
        return new SharedEmailDomainRequest(contextPath.addSegment("sharedEmailDomains").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SharedEmailDomainCollectionRequest sharedEmailDomains() {
        return new SharedEmailDomainCollectionRequest(
                        contextPath.addSegment("sharedEmailDomains"), Optional.empty());
    }

    public FeatureRolloutPolicyRequest featureRolloutPolicies(String id) {
        return new FeatureRolloutPolicyRequest(contextPath.addSegment("featureRolloutPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public FeatureRolloutPolicyCollectionRequest featureRolloutPolicies() {
        return new FeatureRolloutPolicyCollectionRequest(
                        contextPath.addSegment("featureRolloutPolicies"), Optional.empty());
    }

}
