package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementTemplateSettingCategory;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingInstanceCollectionRequest;

@JsonIgnoreType
public class DeviceManagementTemplateSettingCategoryRequest extends EntityRequest<DeviceManagementTemplateSettingCategory> {

    public DeviceManagementTemplateSettingCategoryRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementTemplateSettingCategory.class, contextPath, value, false);
    }

    public DeviceManagementSettingInstanceRequest recommendedSettings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("recommendedSettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementSettingInstanceCollectionRequest recommendedSettings() {
        return new DeviceManagementSettingInstanceCollectionRequest(
                        contextPath.addSegment("recommendedSettings"), Optional.empty());
    }

}
