package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementSettingCategory;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingDefinitionCollectionRequest;

@JsonIgnoreType
public class DeviceManagementSettingCategoryRequest extends EntityRequest<DeviceManagementSettingCategory> {

    public DeviceManagementSettingCategoryRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementSettingCategory.class, contextPath, value, false);
    }

    public DeviceManagementSettingDefinitionRequest settingDefinitions(String id) {
        return new DeviceManagementSettingDefinitionRequest(contextPath.addSegment("settingDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementSettingDefinitionCollectionRequest settingDefinitions() {
        return new DeviceManagementSettingDefinitionCollectionRequest(
                        contextPath.addSegment("settingDefinitions"), Optional.empty());
    }

}
