package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementReusablePolicySetting;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationPolicyCollectionRequest;

@JsonIgnoreType
public class DeviceManagementReusablePolicySettingRequest extends EntityRequest<DeviceManagementReusablePolicySetting> {

    public DeviceManagementReusablePolicySettingRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementReusablePolicySetting.class, contextPath, value, false);
    }

    public DeviceManagementConfigurationPolicyRequest referencingConfigurationPolicies(String id) {
        return new DeviceManagementConfigurationPolicyRequest(contextPath.addSegment("referencingConfigurationPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationPolicyCollectionRequest referencingConfigurationPolicies() {
        return new DeviceManagementConfigurationPolicyCollectionRequest(
                        contextPath.addSegment("referencingConfigurationPolicies"), Optional.empty());
    }

    @Action(name = "clone")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeviceManagementReusablePolicySetting> clone() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<DeviceManagementReusablePolicySetting>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clone"), DeviceManagementReusablePolicySetting.class, _parameters);
    }

}
