package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningStream;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.lang.UnsupportedOperationException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementReports;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementCachedReportConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementExportJobCollectionRequest;

@JsonIgnoreType
public class DeviceManagementReportsRequest extends EntityRequest<DeviceManagementReports> {

    public DeviceManagementReportsRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementReports.class, contextPath, value, false);
    }

    public DeviceManagementCachedReportConfigurationRequest cachedReportConfigurations(String id) {
        return new DeviceManagementCachedReportConfigurationRequest(contextPath.addSegment("cachedReportConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementCachedReportConfigurationCollectionRequest cachedReportConfigurations() {
        return new DeviceManagementCachedReportConfigurationCollectionRequest(
                        contextPath.addSegment("cachedReportConfigurations"), Optional.empty());
    }

    public DeviceManagementExportJobRequest exportJobs(String id) {
        return new DeviceManagementExportJobRequest(contextPath.addSegment("exportJobs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementExportJobCollectionRequest exportJobs() {
        return new DeviceManagementExportJobCollectionRequest(
                        contextPath.addSegment("exportJobs"), Optional.empty());
    }

    @Action(name = "getAppsInstallSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getAppsInstallSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getAppStatusOverviewReport")
    @JsonIgnore
    public FunctionRequestReturningStream getAppStatusOverviewReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getDeviceInstallStatusReport")
    @JsonIgnore
    public FunctionRequestReturningStream getDeviceInstallStatusReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getFailedMobileAppsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getFailedMobileAppsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getFailedMobileAppsSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getFailedMobileAppsSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getRelatedAppsStatusReport")
    @JsonIgnore
    public FunctionRequestReturningStream getRelatedAppsStatusReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getUserInstallStatusReport")
    @JsonIgnore
    public FunctionRequestReturningStream getUserInstallStatusReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCompliancePoliciesReportForDevice")
    @JsonIgnore
    public FunctionRequestReturningStream getCompliancePoliciesReportForDevice(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCompliancePolicyDevicesReport")
    @JsonIgnore
    public FunctionRequestReturningStream getCompliancePolicyDevicesReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCompliancePolicyDeviceSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getCompliancePolicyDeviceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getComplianceSettingDetailsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getComplianceSettingDetailsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getComplianceSettingsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getComplianceSettingsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationPoliciesReportForDevice")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationPoliciesReportForDevice(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationPolicyDevicesReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationPolicyDevicesReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationPolicyDeviceSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationPolicyDeviceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationPolicySettingsDeviceSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationPolicySettingsDeviceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationSettingDetailsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationSettingDetailsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationSettingsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationSettingsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getDeviceConfigurationPolicySettingsSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getDeviceConfigurationPolicySettingsSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getDeviceConfigurationPolicyStatusSummary")
    @JsonIgnore
    public FunctionRequestReturningStream getDeviceConfigurationPolicyStatusSummary(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getQuietTimePolicyUsersReport")
    @JsonIgnore
    public FunctionRequestReturningStream getQuietTimePolicyUsersReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter, String skipToken) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .put("skipToken", "Edm.String", Checks.checkIsAscii(skipToken))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getQuietTimePolicyUserSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getQuietTimePolicyUserSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getEnrollmentConfigurationPoliciesByDevice")
    @JsonIgnore
    public FunctionRequestReturningStream getEnrollmentConfigurationPoliciesByDevice(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getActiveMalwareReport")
    @JsonIgnore
    public FunctionRequestReturningStream getActiveMalwareReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getActiveMalwareSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getActiveMalwareSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getMalwareSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getMalwareSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getUnhealthyDefenderAgentsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getUnhealthyDefenderAgentsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getUnhealthyFirewallReport")
    @JsonIgnore
    public FunctionRequestReturningStream getUnhealthyFirewallReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getUnhealthyFirewallSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getUnhealthyFirewallSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getAllCertificatesReport")
    @JsonIgnore
    public FunctionRequestReturningStream getAllCertificatesReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCertificatesReport")
    @JsonIgnore
    public FunctionRequestReturningStream getCertificatesReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getGroupPolicySettingsDeviceSettingsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getGroupPolicySettingsDeviceSettingsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigManagerDevicePolicyStatusReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigManagerDevicePolicyStatusReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getRemoteAssistanceSessionsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getRemoteAssistanceSessionsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCachedReport")
    @JsonIgnore
    public FunctionRequestReturningStream getCachedReport(String id, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCompliancePolicyNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getCompliancePolicyNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getCompliancePolicyNonComplianceSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getCompliancePolicyNonComplianceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getComplianceSettingNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getComplianceSettingNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationPolicyNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationPolicyNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationPolicyNonComplianceSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationPolicyNonComplianceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getConfigurationSettingNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getConfigurationSettingNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getDeviceManagementIntentPerSettingContributingProfiles")
    @JsonIgnore
    public FunctionRequestReturningStream getDeviceManagementIntentPerSettingContributingProfiles(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getDeviceManagementIntentSettingsReport")
    @JsonIgnore
    public FunctionRequestReturningStream getDeviceManagementIntentSettingsReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getDeviceNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getDeviceNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getHistoricalReport")
    @JsonIgnore
    public FunctionRequestReturningStream getHistoricalReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getPolicyNonComplianceMetadata")
    @JsonIgnore
    public FunctionRequestReturningStream getPolicyNonComplianceMetadata(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getPolicyNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getPolicyNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getPolicyNonComplianceSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getPolicyNonComplianceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getReportFilters")
    @JsonIgnore
    public FunctionRequestReturningStream getReportFilters(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getSettingNonComplianceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getSettingNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getWindowsQualityUpdateAlertsPerPolicyPerDeviceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getWindowsQualityUpdateAlertsPerPolicyPerDeviceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getWindowsQualityUpdateAlertSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getWindowsQualityUpdateAlertSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getWindowsUpdateAlertsPerPolicyPerDeviceReport")
    @JsonIgnore
    public FunctionRequestReturningStream getWindowsUpdateAlertsPerPolicyPerDeviceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getWindowsUpdateAlertSummaryReport")
    @JsonIgnore
    public FunctionRequestReturningStream getWindowsUpdateAlertSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

}
