package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementIntentSettingCategory;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingInstanceCollectionRequest;

@JsonIgnoreType
public class DeviceManagementIntentSettingCategoryRequest extends EntityRequest<DeviceManagementIntentSettingCategory> {

    public DeviceManagementIntentSettingCategoryRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementIntentSettingCategory.class, contextPath, value, false);
    }

    public DeviceManagementSettingInstanceRequest settings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("settings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementSettingInstanceCollectionRequest settings() {
        return new DeviceManagementSettingInstanceCollectionRequest(
                        contextPath.addSegment("settings"), Optional.empty());
    }

}
