package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementExchangeOnPremisesPolicy;

@JsonIgnoreType
public class DeviceManagementExchangeOnPremisesPolicyRequest extends EntityRequest<DeviceManagementExchangeOnPremisesPolicy> {

    public DeviceManagementExchangeOnPremisesPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementExchangeOnPremisesPolicy.class, contextPath, value, false);
    }

    public OnPremisesConditionalAccessSettingsRequest conditionalAccessSettings() {
        return new OnPremisesConditionalAccessSettingsRequest(contextPath.addSegment("conditionalAccessSettings"), Optional.empty());
    }

}
