package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementConfigurationSetting;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationSettingDefinitionCollectionRequest;

@JsonIgnoreType
public class DeviceManagementConfigurationSettingRequest extends EntityRequest<DeviceManagementConfigurationSetting> {

    public DeviceManagementConfigurationSettingRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementConfigurationSetting.class, contextPath, value, false);
    }

    public DeviceManagementConfigurationSettingDefinitionRequest settingDefinitions(String id) {
        return new DeviceManagementConfigurationSettingDefinitionRequest(contextPath.addSegment("settingDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationSettingDefinitionCollectionRequest settingDefinitions() {
        return new DeviceManagementConfigurationSettingDefinitionCollectionRequest(
                        contextPath.addSegment("settingDefinitions"), Optional.empty());
    }

}
