package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementCompliancePolicy;
import odata.msgraph.client.beta.entity.DeviceManagementComplianceScheduledActionForRule;
import odata.msgraph.client.beta.entity.DeviceManagementConfigurationPolicyAssignment;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementComplianceScheduledActionForRuleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationPolicyAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationSettingCollectionRequest;

@JsonIgnoreType
public class DeviceManagementCompliancePolicyRequest extends EntityRequest<DeviceManagementCompliancePolicy> {

    public DeviceManagementCompliancePolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementCompliancePolicy.class, contextPath, value, false);
    }

    public DeviceManagementConfigurationPolicyAssignmentRequest assignments(String id) {
        return new DeviceManagementConfigurationPolicyAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationPolicyAssignmentCollectionRequest assignments() {
        return new DeviceManagementConfigurationPolicyAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public DeviceManagementComplianceScheduledActionForRuleRequest scheduledActionsForRule(String id) {
        return new DeviceManagementComplianceScheduledActionForRuleRequest(contextPath.addSegment("scheduledActionsForRule").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementComplianceScheduledActionForRuleCollectionRequest scheduledActionsForRule() {
        return new DeviceManagementComplianceScheduledActionForRuleCollectionRequest(
                        contextPath.addSegment("scheduledActionsForRule"), Optional.empty());
    }

    public DeviceManagementConfigurationSettingRequest settings(String id) {
        return new DeviceManagementConfigurationSettingRequest(contextPath.addSegment("settings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationSettingCollectionRequest settings() {
        return new DeviceManagementConfigurationSettingCollectionRequest(
                        contextPath.addSegment("settings"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceManagementConfigurationPolicyAssignment> assign(List<DeviceManagementConfigurationPolicyAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.deviceManagementConfigurationPolicyAssignment)", assignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), DeviceManagementConfigurationPolicyAssignment.class, _parameters);
    }

    @Action(name = "setScheduledActions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceManagementComplianceScheduledActionForRule> setScheduledActions(List<DeviceManagementComplianceScheduledActionForRule> scheduledActions) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("scheduledActions", "Collection(microsoft.graph.deviceManagementComplianceScheduledActionForRule)", scheduledActions)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setScheduledActions"), DeviceManagementComplianceScheduledActionForRule.class, _parameters);
    }

}
