package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementAutopilotEvent;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementAutopilotPolicyStatusDetailCollectionRequest;

@JsonIgnoreType
public class DeviceManagementAutopilotEventRequest extends EntityRequest<DeviceManagementAutopilotEvent> {

    public DeviceManagementAutopilotEventRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementAutopilotEvent.class, contextPath, value, false);
    }

    public DeviceManagementAutopilotPolicyStatusDetailRequest policyStatusDetails(String id) {
        return new DeviceManagementAutopilotPolicyStatusDetailRequest(contextPath.addSegment("policyStatusDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementAutopilotPolicyStatusDetailCollectionRequest policyStatusDetails() {
        return new DeviceManagementAutopilotPolicyStatusDetailCollectionRequest(
                        contextPath.addSegment("policyStatusDetails"), Optional.empty());
    }

}
