package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceEnrollmentConfiguration;
import odata.msgraph.client.beta.entity.EnrollmentConfigurationAssignment;
import odata.msgraph.client.beta.entity.collection.request.EnrollmentConfigurationAssignmentCollectionRequest;

@JsonIgnoreType
public class DeviceEnrollmentConfigurationRequest extends EntityRequest<DeviceEnrollmentConfiguration> {

    public DeviceEnrollmentConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceEnrollmentConfiguration.class, contextPath, value, false);
    }

    public EnrollmentConfigurationAssignmentRequest assignments(String id) {
        return new EnrollmentConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EnrollmentConfigurationAssignmentCollectionRequest assignments() {
        return new EnrollmentConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<EnrollmentConfigurationAssignment> enrollmentConfigurationAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("enrollmentConfigurationAssignments", "Collection(microsoft.graph.enrollmentConfigurationAssignment)", enrollmentConfigurationAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Action(name = "setPriority")
    @JsonIgnore
    public ActionRequestNoReturn setPriority(Integer priority) {
        Preconditions.checkNotNull(priority, "priority cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("priority", "Edm.Int32", priority)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setPriority"), _parameters);
    }

}
