package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceCompliancePolicy;
import odata.msgraph.client.beta.entity.DeviceCompliancePolicyAssignment;
import odata.msgraph.client.beta.entity.DeviceComplianceScheduledActionForRule;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCompliancePolicyAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceScheduledActionForRuleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceUserStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SettingStateDeviceSummaryCollectionRequest;

@JsonIgnoreType
public class DeviceCompliancePolicyRequest extends EntityRequest<DeviceCompliancePolicy> {

    public DeviceCompliancePolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceCompliancePolicy.class, contextPath, value, false);
    }

    public DeviceCompliancePolicyAssignmentRequest assignments(String id) {
        return new DeviceCompliancePolicyAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceCompliancePolicyAssignmentCollectionRequest assignments() {
        return new DeviceCompliancePolicyAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public SettingStateDeviceSummaryRequest deviceSettingStateSummaries(String id) {
        return new SettingStateDeviceSummaryRequest(contextPath.addSegment("deviceSettingStateSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SettingStateDeviceSummaryCollectionRequest deviceSettingStateSummaries() {
        return new SettingStateDeviceSummaryCollectionRequest(
                        contextPath.addSegment("deviceSettingStateSummaries"), Optional.empty());
    }

    public DeviceComplianceDeviceStatusRequest deviceStatuses(String id) {
        return new DeviceComplianceDeviceStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceComplianceDeviceStatusCollectionRequest deviceStatuses() {
        return new DeviceComplianceDeviceStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"), Optional.empty());
    }

    public DeviceComplianceDeviceOverviewRequest deviceStatusOverview() {
        return new DeviceComplianceDeviceOverviewRequest(contextPath.addSegment("deviceStatusOverview"), Optional.empty());
    }

    public DeviceComplianceScheduledActionForRuleRequest scheduledActionsForRule(String id) {
        return new DeviceComplianceScheduledActionForRuleRequest(contextPath.addSegment("scheduledActionsForRule").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceComplianceScheduledActionForRuleCollectionRequest scheduledActionsForRule() {
        return new DeviceComplianceScheduledActionForRuleCollectionRequest(
                        contextPath.addSegment("scheduledActionsForRule"), Optional.empty());
    }

    public DeviceComplianceUserStatusRequest userStatuses(String id) {
        return new DeviceComplianceUserStatusRequest(contextPath.addSegment("userStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceComplianceUserStatusCollectionRequest userStatuses() {
        return new DeviceComplianceUserStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"), Optional.empty());
    }

    public DeviceComplianceUserOverviewRequest userStatusOverview() {
        return new DeviceComplianceUserOverviewRequest(contextPath.addSegment("userStatusOverview"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceCompliancePolicyAssignment> assign(List<DeviceCompliancePolicyAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.deviceCompliancePolicyAssignment)", assignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), DeviceCompliancePolicyAssignment.class, _parameters);
    }

    @Action(name = "scheduleActionsForRules")
    @JsonIgnore
    public ActionRequestNoReturn scheduleActionsForRules(List<DeviceComplianceScheduledActionForRule> deviceComplianceScheduledActionForRules) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceComplianceScheduledActionForRules", "Collection(microsoft.graph.deviceComplianceScheduledActionForRule)", deviceComplianceScheduledActionForRules)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.scheduleActionsForRules"), _parameters);
    }

}
