package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DetectedApp;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCollectionRequest;

@JsonIgnoreType
public class DetectedAppRequest extends EntityRequest<DetectedApp> {

    public DetectedAppRequest(ContextPath contextPath, Optional<Object> value) {
        super(DetectedApp.class, contextPath, value, false);
    }

    public ManagedDeviceRequest managedDevices(String id) {
        return new ManagedDeviceRequest(contextPath.addSegment("managedDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceCollectionRequest managedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"), Optional.empty());
    }

}
