package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DelegatedAdminRelationship;
import odata.msgraph.client.beta.entity.collection.request.DelegatedAdminAccessAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DelegatedAdminRelationshipOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DelegatedAdminRelationshipRequestCollectionRequest;

@JsonIgnoreType
public class DelegatedAdminRelationshipRequest extends EntityRequest<DelegatedAdminRelationship> {

    public DelegatedAdminRelationshipRequest(ContextPath contextPath, Optional<Object> value) {
        super(DelegatedAdminRelationship.class, contextPath, value, false);
    }

    public DelegatedAdminAccessAssignmentRequest accessAssignments(String id) {
        return new DelegatedAdminAccessAssignmentRequest(contextPath.addSegment("accessAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DelegatedAdminAccessAssignmentCollectionRequest accessAssignments() {
        return new DelegatedAdminAccessAssignmentCollectionRequest(
                        contextPath.addSegment("accessAssignments"), Optional.empty());
    }

    public DelegatedAdminRelationshipOperationRequest operations(String id) {
        return new DelegatedAdminRelationshipOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DelegatedAdminRelationshipOperationCollectionRequest operations() {
        return new DelegatedAdminRelationshipOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

    public DelegatedAdminRelationshipRequestRequest requests(String id) {
        return new DelegatedAdminRelationshipRequestRequest(contextPath.addSegment("requests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DelegatedAdminRelationshipRequestCollectionRequest requests() {
        return new DelegatedAdminRelationshipRequestCollectionRequest(
                        contextPath.addSegment("requests"), Optional.empty());
    }

}
