package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ContentClassification;
import odata.msgraph.client.beta.complex.ExactMatchClassificationResult;
import odata.msgraph.client.beta.entity.ClassificationJobResponse;
import odata.msgraph.client.beta.entity.DataClassificationService;
import odata.msgraph.client.beta.entity.collection.request.ExactMatchDataStoreCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExactMatchUploadAgentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.JobResponseBaseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SensitiveTypeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SensitivityLabelCollectionRequest;
import odata.msgraph.client.beta.enums.MlClassificationMatchTolerance;
import odata.msgraph.client.beta.enums.SensitiveTypeScope;

@JsonIgnoreType
public class DataClassificationServiceRequest extends EntityRequest<DataClassificationService> {

    public DataClassificationServiceRequest(ContextPath contextPath, Optional<Object> value) {
        super(DataClassificationService.class, contextPath, value, false);
    }

    public ExactMatchDataStoreRequest exactMatchDataStores(String id) {
        return new ExactMatchDataStoreRequest(contextPath.addSegment("exactMatchDataStores").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExactMatchDataStoreCollectionRequest exactMatchDataStores() {
        return new ExactMatchDataStoreCollectionRequest(
                        contextPath.addSegment("exactMatchDataStores"), Optional.empty());
    }

    public JobResponseBaseRequest classifyFileJobs(String id) {
        return new JobResponseBaseRequest(contextPath.addSegment("classifyFileJobs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public JobResponseBaseCollectionRequest classifyFileJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("classifyFileJobs"), Optional.empty());
    }

    public JobResponseBaseRequest classifyTextJobs(String id) {
        return new JobResponseBaseRequest(contextPath.addSegment("classifyTextJobs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public JobResponseBaseCollectionRequest classifyTextJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("classifyTextJobs"), Optional.empty());
    }

    public JobResponseBaseRequest evaluateDlpPoliciesJobs(String id) {
        return new JobResponseBaseRequest(contextPath.addSegment("evaluateDlpPoliciesJobs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public JobResponseBaseCollectionRequest evaluateDlpPoliciesJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("evaluateDlpPoliciesJobs"), Optional.empty());
    }

    public JobResponseBaseRequest evaluateLabelJobs(String id) {
        return new JobResponseBaseRequest(contextPath.addSegment("evaluateLabelJobs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public JobResponseBaseCollectionRequest evaluateLabelJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("evaluateLabelJobs"), Optional.empty());
    }

    public JobResponseBaseRequest jobs(String id) {
        return new JobResponseBaseRequest(contextPath.addSegment("jobs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public JobResponseBaseCollectionRequest jobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("jobs"), Optional.empty());
    }

    public SensitiveTypeRequest sensitiveTypes(String id) {
        return new SensitiveTypeRequest(contextPath.addSegment("sensitiveTypes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SensitiveTypeCollectionRequest sensitiveTypes() {
        return new SensitiveTypeCollectionRequest(
                        contextPath.addSegment("sensitiveTypes"), Optional.empty());
    }

    public SensitivityLabelRequest sensitivityLabels(String id) {
        return new SensitivityLabelRequest(contextPath.addSegment("sensitivityLabels").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SensitivityLabelCollectionRequest sensitivityLabels() {
        return new SensitivityLabelCollectionRequest(
                        contextPath.addSegment("sensitivityLabels"), Optional.empty());
    }

    public ExactMatchUploadAgentRequest exactMatchUploadAgents(String id) {
        return new ExactMatchUploadAgentRequest(contextPath.addSegment("exactMatchUploadAgents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExactMatchUploadAgentCollectionRequest exactMatchUploadAgents() {
        return new ExactMatchUploadAgentCollectionRequest(
                        contextPath.addSegment("exactMatchUploadAgents"), Optional.empty());
    }

    @Action(name = "classifyFile")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ClassificationJobResponse> classifyFile(String file, List<String> sensitiveTypeIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("file", "Edm.Stream", file)
            .put("sensitiveTypeIds", "Collection(Edm.String)", Checks.checkIsAscii(sensitiveTypeIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ClassificationJobResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.classifyFile"), ClassificationJobResponse.class, _parameters);
    }

    @Action(name = "classifyText")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ClassificationJobResponse> classifyText(String text, String fileExtension, List<String> sensitiveTypeIds, SensitiveTypeScope scopesToRun, MlClassificationMatchTolerance matchTolerancesToInclude) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("fileExtension", "Edm.String", Checks.checkIsAscii(fileExtension))
            .put("sensitiveTypeIds", "Collection(Edm.String)", Checks.checkIsAscii(sensitiveTypeIds))
            .put("scopesToRun", "microsoft.graph.sensitiveTypeScope", scopesToRun)
            .put("matchTolerancesToInclude", "microsoft.graph.mlClassificationMatchTolerance", matchTolerancesToInclude)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ClassificationJobResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.classifyText"), ClassificationJobResponse.class, _parameters);
    }

    @Action(name = "classifyExactMatches")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExactMatchClassificationResult> classifyExactMatches(String text, String timeoutInMs, List<String> sensitiveTypeIds, List<ContentClassification> contentClassifications) {
        Preconditions.checkNotNull(contentClassifications, "contentClassifications cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("timeoutInMs", "Edm.String", Checks.checkIsAscii(timeoutInMs))
            .put("sensitiveTypeIds", "Collection(Edm.String)", Checks.checkIsAscii(sensitiveTypeIds))
            .put("contentClassifications", "Collection(microsoft.graph.contentClassification)", contentClassifications)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExactMatchClassificationResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.classifyExactMatches"), ExactMatchClassificationResult.class, _parameters);
    }

}
