package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.CustomerPaymentJournal;
import odata.msgraph.client.beta.entity.collection.request.CustomerPaymentCollectionRequest;

@JsonIgnoreType
public class CustomerPaymentJournalRequest extends EntityRequest<CustomerPaymentJournal> {

    public CustomerPaymentJournalRequest(ContextPath contextPath, Optional<Object> value) {
        super(CustomerPaymentJournal.class, contextPath, value, false);
    }

    public AccountRequest account() {
        return new AccountRequest(contextPath.addSegment("account"), Optional.empty());
    }

    public CustomerPaymentRequest customerPayments(String id) {
        return new CustomerPaymentRequest(contextPath.addSegment("customerPayments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CustomerPaymentCollectionRequest customerPayments() {
        return new CustomerPaymentCollectionRequest(
                        contextPath.addSegment("customerPayments"), Optional.empty());
    }

}
