package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ConversationThread;
import odata.msgraph.client.beta.entity.Post;
import odata.msgraph.client.beta.entity.collection.request.PostCollectionRequest;

@JsonIgnoreType
public class ConversationThreadRequest extends EntityRequest<ConversationThread> {

    public ConversationThreadRequest(ContextPath contextPath, Optional<Object> value) {
        super(ConversationThread.class, contextPath, value, false);
    }

    public PostRequest posts(String id) {
        return new PostRequest(contextPath.addSegment("posts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PostCollectionRequest posts() {
        return new PostCollectionRequest(
                        contextPath.addSegment("posts"), Optional.empty());
    }

    @Action(name = "reply")
    @JsonIgnore
    public ActionRequestNoReturn reply(Post post) {
        Preconditions.checkNotNull(post, "post cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Post", "microsoft.graph.post", post)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reply"), _parameters);
    }

}
