package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.CloudPcOnPremisesConnection;

@JsonIgnoreType
public class CloudPcOnPremisesConnectionRequest extends EntityRequest<CloudPcOnPremisesConnection> {

    public CloudPcOnPremisesConnectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(CloudPcOnPremisesConnection.class, contextPath, value, false);
    }

    @Action(name = "runHealthChecks")
    @JsonIgnore
    public ActionRequestNoReturn runHealthChecks() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.runHealthChecks"), _parameters);
    }

    @Action(name = "updateAdDomainPassword")
    @JsonIgnore
    public ActionRequestNoReturn updateAdDomainPassword(String adDomainPassword) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("adDomainPassword", "Edm.String", Checks.checkIsAscii(adDomainPassword))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateAdDomainPassword"), _parameters);
    }

}
