package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.CloudPC;
import odata.msgraph.client.beta.enums.CloudPcOperatingSystem;
import odata.msgraph.client.beta.enums.CloudPcUserAccountType;

@JsonIgnoreType
public class CloudPCRequest extends EntityRequest<CloudPC> {

    public CloudPCRequest(ContextPath contextPath, Optional<Object> value) {
        super(CloudPC.class, contextPath, value, false);
    }

    @Action(name = "changeUserAccountType")
    @JsonIgnore
    public ActionRequestNoReturn changeUserAccountType(CloudPcUserAccountType userAccountType) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userAccountType", "microsoft.graph.cloudPcUserAccountType", userAccountType)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.changeUserAccountType"), _parameters);
    }

    @Action(name = "endGracePeriod")
    @JsonIgnore
    public ActionRequestNoReturn endGracePeriod() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.endGracePeriod"), _parameters);
    }

    @Action(name = "reboot")
    @JsonIgnore
    public ActionRequestNoReturn reboot() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reboot"), _parameters);
    }

    @Action(name = "rename")
    @JsonIgnore
    public ActionRequestNoReturn rename(String displayName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rename"), _parameters);
    }

    @Action(name = "reprovision")
    @JsonIgnore
    public ActionRequestNoReturn reprovision(CloudPcUserAccountType userAccountType, CloudPcOperatingSystem osVersion) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userAccountType", "microsoft.graph.cloudPcUserAccountType", userAccountType)
            .put("osVersion", "microsoft.graph.cloudPcOperatingSystem", osVersion)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reprovision"), _parameters);
    }

    @Action(name = "troubleshoot")
    @JsonIgnore
    public ActionRequestNoReturn troubleshoot() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.troubleshoot"), _parameters);
    }

}
