package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ChatMessage;
import odata.msgraph.client.beta.entity.collection.request.ChatMessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ChatMessageHostedContentCollectionRequest;

@JsonIgnoreType
public class ChatMessageRequest extends EntityRequest<ChatMessage> {

    public ChatMessageRequest(ContextPath contextPath, Optional<Object> value) {
        super(ChatMessage.class, contextPath, value, false);
    }

    public ChatMessageHostedContentRequest hostedContents(String id) {
        return new ChatMessageHostedContentRequest(contextPath.addSegment("hostedContents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ChatMessageHostedContentCollectionRequest hostedContents() {
        return new ChatMessageHostedContentCollectionRequest(
                        contextPath.addSegment("hostedContents"), Optional.empty());
    }

    public ChatMessageRequest replies(String id) {
        return new ChatMessageRequest(contextPath.addSegment("replies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ChatMessageCollectionRequest replies() {
        return new ChatMessageCollectionRequest(
                        contextPath.addSegment("replies"), Optional.empty());
    }

}
