package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ProvisionChannelEmailResult;
import odata.msgraph.client.beta.entity.Channel;
import odata.msgraph.client.beta.entity.collection.request.ChatMessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationMemberCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsTabCollectionRequest;

@JsonIgnoreType
public class ChannelRequest extends EntityRequest<Channel> {

    public ChannelRequest(ContextPath contextPath, Optional<Object> value) {
        super(Channel.class, contextPath, value, false);
    }

    public DriveItemRequest filesFolder() {
        return new DriveItemRequest(contextPath.addSegment("filesFolder"), Optional.empty());
    }

    public ConversationMemberRequest members(String id) {
        return new ConversationMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConversationMemberCollectionRequest members() {
        return new ConversationMemberCollectionRequest(
                        contextPath.addSegment("members"), Optional.empty());
    }

    public ChatMessageRequest messages(String id) {
        return new ChatMessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ChatMessageCollectionRequest messages() {
        return new ChatMessageCollectionRequest(
                        contextPath.addSegment("messages"), Optional.empty());
    }

    public TeamsTabRequest tabs(String id) {
        return new TeamsTabRequest(contextPath.addSegment("tabs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsTabCollectionRequest tabs() {
        return new TeamsTabCollectionRequest(
                        contextPath.addSegment("tabs"), Optional.empty());
    }

    @Action(name = "completeMigration")
    @JsonIgnore
    public ActionRequestNoReturn completeMigration() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.completeMigration"), _parameters);
    }

    @Action(name = "provisionEmail")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ProvisionChannelEmailResult> provisionEmail() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<ProvisionChannelEmailResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.provisionEmail"), ProvisionChannelEmailResult.class, _parameters);
    }

    @Action(name = "removeEmail")
    @JsonIgnore
    public ActionRequestNoReturn removeEmail() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeEmail"), _parameters);
    }

}
