package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CertificateConnectorHealthMetricValue;
import odata.msgraph.client.beta.complex.KeyLongValuePair;
import odata.msgraph.client.beta.complex.TimeSeriesParameter;
import odata.msgraph.client.beta.entity.CertificateConnectorDetails;

@JsonIgnoreType
public class CertificateConnectorDetailsRequest extends EntityRequest<CertificateConnectorDetails> {

    public CertificateConnectorDetailsRequest(ContextPath contextPath, Optional<Object> value) {
        super(CertificateConnectorDetails.class, contextPath, value, false);
    }

    @Action(name = "getHealthMetrics")
    @JsonIgnore
    public CollectionPageNonEntityRequest<KeyLongValuePair> getHealthMetrics(List<String> metricNames) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("metricNames", "Collection(Edm.String)", Checks.checkIsAscii(metricNames))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getHealthMetrics"), KeyLongValuePair.class, _parameters);
    }

    @Action(name = "getHealthMetricTimeSeries")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CertificateConnectorHealthMetricValue> getHealthMetricTimeSeries(TimeSeriesParameter timeSeries) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("timeSeries", "microsoft.graph.timeSeriesParameter", timeSeries)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getHealthMetricTimeSeries"), CertificateConnectorHealthMetricValue.class, _parameters);
    }

}
