package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IncomingCallOptions;
import odata.msgraph.client.beta.complex.InvitationParticipantInfo;
import odata.msgraph.client.beta.complex.MediaConfig;
import odata.msgraph.client.beta.complex.ParticipantInfo;
import odata.msgraph.client.beta.complex.Prompt;
import odata.msgraph.client.beta.entity.Call;
import odata.msgraph.client.beta.entity.CancelMediaProcessingOperation;
import odata.msgraph.client.beta.entity.MuteParticipantOperation;
import odata.msgraph.client.beta.entity.PlayPromptOperation;
import odata.msgraph.client.beta.entity.RecordOperation;
import odata.msgraph.client.beta.entity.SubscribeToToneOperation;
import odata.msgraph.client.beta.entity.UnmuteParticipantOperation;
import odata.msgraph.client.beta.entity.UpdateRecordingStatusOperation;
import odata.msgraph.client.beta.entity.collection.request.AudioRoutingGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CommsOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ParticipantCollectionRequest;
import odata.msgraph.client.beta.enums.CallDisposition;
import odata.msgraph.client.beta.enums.Modality;
import odata.msgraph.client.beta.enums.RecordingStatus;
import odata.msgraph.client.beta.enums.RejectReason;
import odata.msgraph.client.beta.enums.ScreenSharingRole;

@JsonIgnoreType
public class CallRequest extends EntityRequest<Call> {

    public CallRequest(ContextPath contextPath, Optional<Object> value) {
        super(Call.class, contextPath, value, false);
    }

    public AudioRoutingGroupRequest audioRoutingGroups(String id) {
        return new AudioRoutingGroupRequest(contextPath.addSegment("audioRoutingGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AudioRoutingGroupCollectionRequest audioRoutingGroups() {
        return new AudioRoutingGroupCollectionRequest(
                        contextPath.addSegment("audioRoutingGroups"), Optional.empty());
    }

    public CommsOperationRequest operations(String id) {
        return new CommsOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CommsOperationCollectionRequest operations() {
        return new CommsOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

    public ParticipantRequest participants(String id) {
        return new ParticipantRequest(contextPath.addSegment("participants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ParticipantCollectionRequest participants() {
        return new ParticipantCollectionRequest(
                        contextPath.addSegment("participants"), Optional.empty());
    }

    @Action(name = "redirect")
    @JsonIgnore
    public ActionRequestNoReturn redirect(List<InvitationParticipantInfo> targets, CallDisposition targetDisposition, Integer timeout, Boolean maskCallee, Boolean maskCaller, String callbackUri) {
        Preconditions.checkNotNull(targets, "targets cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("targets", "Collection(microsoft.graph.invitationParticipantInfo)", targets)
            .put("targetDisposition", "microsoft.graph.callDisposition", targetDisposition)
            .put("timeout", "Edm.Int32", timeout)
            .put("maskCallee", "Edm.Boolean", maskCallee)
            .put("maskCaller", "Edm.Boolean", maskCaller)
            .put("callbackUri", "Edm.String", Checks.checkIsAscii(callbackUri))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.redirect"), _parameters);
    }

    @Action(name = "answer")
    @JsonIgnore
    public ActionRequestNoReturn answer(String callbackUri, MediaConfig mediaConfig, List<Modality> acceptedModalities, Integer participantCapacity, IncomingCallOptions callOptions) {
        Preconditions.checkNotNull(callbackUri, "callbackUri cannot be null");
        Preconditions.checkNotNull(mediaConfig, "mediaConfig cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("callbackUri", "Edm.String", Checks.checkIsAscii(callbackUri))
            .put("mediaConfig", "microsoft.graph.mediaConfig", mediaConfig)
            .put("acceptedModalities", "Collection(microsoft.graph.modality)", acceptedModalities)
            .put("participantCapacity", "Edm.Int32", participantCapacity)
            .put("callOptions", "microsoft.graph.incomingCallOptions", callOptions)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.answer"), _parameters);
    }

    @Action(name = "cancelMediaProcessing")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CancelMediaProcessingOperation> cancelMediaProcessing(String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CancelMediaProcessingOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancelMediaProcessing"), CancelMediaProcessingOperation.class, _parameters);
    }

    @Action(name = "changeScreenSharingRole")
    @JsonIgnore
    public ActionRequestNoReturn changeScreenSharingRole(ScreenSharingRole role) {
        Preconditions.checkNotNull(role, "role cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("role", "microsoft.graph.screenSharingRole", role)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.changeScreenSharingRole"), _parameters);
    }

    @Action(name = "keepAlive")
    @JsonIgnore
    public ActionRequestNoReturn keepAlive() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.keepAlive"), _parameters);
    }

    @Action(name = "mute")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MuteParticipantOperation> mute(String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MuteParticipantOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.mute"), MuteParticipantOperation.class, _parameters);
    }

    @Action(name = "playPrompt")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PlayPromptOperation> playPrompt(List<Prompt> prompts, Boolean loop, String clientContext) {
        Preconditions.checkNotNull(prompts, "prompts cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("prompts", "Collection(microsoft.graph.prompt)", prompts)
            .put("loop", "Edm.Boolean", loop)
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PlayPromptOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.playPrompt"), PlayPromptOperation.class, _parameters);
    }

    @Action(name = "record")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecordOperation> record(List<Prompt> prompts, Boolean bargeInAllowed, Integer initialSilenceTimeoutInSeconds, Integer maxSilenceTimeoutInSeconds, Integer maxRecordDurationInSeconds, Boolean playBeep, Boolean streamWhileRecording, List<String> stopTones, String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("prompts", "Collection(microsoft.graph.prompt)", prompts)
            .put("bargeInAllowed", "Edm.Boolean", bargeInAllowed)
            .put("initialSilenceTimeoutInSeconds", "Edm.Int32", initialSilenceTimeoutInSeconds)
            .put("maxSilenceTimeoutInSeconds", "Edm.Int32", maxSilenceTimeoutInSeconds)
            .put("maxRecordDurationInSeconds", "Edm.Int32", maxRecordDurationInSeconds)
            .put("playBeep", "Edm.Boolean", playBeep)
            .put("streamWhileRecording", "Edm.Boolean", streamWhileRecording)
            .put("stopTones", "Collection(Edm.String)", Checks.checkIsAscii(stopTones))
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RecordOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.record"), RecordOperation.class, _parameters);
    }

    @Action(name = "recordResponse")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecordOperation> recordResponse(List<Prompt> prompts, Boolean bargeInAllowed, Integer initialSilenceTimeoutInSeconds, Integer maxSilenceTimeoutInSeconds, Integer maxRecordDurationInSeconds, Boolean playBeep, Boolean streamWhileRecording, List<String> stopTones, String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("prompts", "Collection(microsoft.graph.prompt)", prompts)
            .put("bargeInAllowed", "Edm.Boolean", bargeInAllowed)
            .put("initialSilenceTimeoutInSeconds", "Edm.Int32", initialSilenceTimeoutInSeconds)
            .put("maxSilenceTimeoutInSeconds", "Edm.Int32", maxSilenceTimeoutInSeconds)
            .put("maxRecordDurationInSeconds", "Edm.Int32", maxRecordDurationInSeconds)
            .put("playBeep", "Edm.Boolean", playBeep)
            .put("streamWhileRecording", "Edm.Boolean", streamWhileRecording)
            .put("stopTones", "Collection(Edm.String)", Checks.checkIsAscii(stopTones))
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RecordOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.recordResponse"), RecordOperation.class, _parameters);
    }

    @Action(name = "reject")
    @JsonIgnore
    public ActionRequestNoReturn reject(RejectReason reason, String callbackUri) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reason", "microsoft.graph.rejectReason", reason)
            .put("callbackUri", "Edm.String", Checks.checkIsAscii(callbackUri))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reject"), _parameters);
    }

    @Action(name = "subscribeToTone")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<SubscribeToToneOperation> subscribeToTone(String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<SubscribeToToneOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.subscribeToTone"), SubscribeToToneOperation.class, _parameters);
    }

    @Action(name = "transfer")
    @JsonIgnore
    public ActionRequestNoReturn transfer(InvitationParticipantInfo transferTarget, ParticipantInfo transferee) {
        Preconditions.checkNotNull(transferTarget, "transferTarget cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("transferTarget", "microsoft.graph.invitationParticipantInfo", transferTarget)
            .put("transferee", "microsoft.graph.participantInfo", transferee)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.transfer"), _parameters);
    }

    @Action(name = "unmute")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UnmuteParticipantOperation> unmute(String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UnmuteParticipantOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unmute"), UnmuteParticipantOperation.class, _parameters);
    }

    @Action(name = "updateRecordingStatus")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UpdateRecordingStatusOperation> updateRecordingStatus(RecordingStatus status, String clientContext) {
        Preconditions.checkNotNull(status, "status cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("status", "microsoft.graph.recordingStatus", status)
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UpdateRecordingStatusOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateRecordingStatus"), UpdateRecordingStatusOperation.class, _parameters);
    }

}
