package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Calendar;
import odata.msgraph.client.beta.entity.CalendarSharingMessage;

@JsonIgnoreType
public class CalendarSharingMessageRequest extends EntityRequest<CalendarSharingMessage> {

    public CalendarSharingMessageRequest(ContextPath contextPath, Optional<Object> value) {
        super(CalendarSharingMessage.class, contextPath, value, false);
    }

    @Action(name = "accept")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Calendar> accept() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Calendar>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.accept"), Calendar.class, _parameters);
    }

}
