package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DateTimeTimeZone;
import odata.msgraph.client.beta.complex.ScheduleInformation;
import odata.msgraph.client.beta.entity.Calendar;
import odata.msgraph.client.beta.entity.collection.request.CalendarPermissionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.enums.CalendarRoleType;

@JsonIgnoreType
public class CalendarRequest extends EntityRequest<Calendar> {

    public CalendarRequest(ContextPath contextPath, Optional<Object> value) {
        super(Calendar.class, contextPath, value, false);
    }

    public CalendarPermissionRequest calendarPermissions(String id) {
        return new CalendarPermissionRequest(contextPath.addSegment("calendarPermissions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CalendarPermissionCollectionRequest calendarPermissions() {
        return new CalendarPermissionCollectionRequest(
                        contextPath.addSegment("calendarPermissions"), Optional.empty());
    }

    public EventRequest calendarView(String id) {
        return new EventRequest(contextPath.addSegment("calendarView").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EventCollectionRequest calendarView() {
        return new EventCollectionRequest(
                        contextPath.addSegment("calendarView"), Optional.empty());
    }

    public EventRequest events(String id) {
        return new EventRequest(contextPath.addSegment("events").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EventCollectionRequest events() {
        return new EventCollectionRequest(
                        contextPath.addSegment("events"), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"), Optional.empty());
    }

    @Action(name = "getSchedule")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ScheduleInformation> getSchedule(List<String> schedules, DateTimeTimeZone endTime, DateTimeTimeZone startTime, Integer availabilityViewInterval) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Schedules", "Collection(Edm.String)", Checks.checkIsAscii(schedules))
            .put("EndTime", "microsoft.graph.dateTimeTimeZone", endTime)
            .put("StartTime", "microsoft.graph.dateTimeTimeZone", startTime)
            .put("AvailabilityViewInterval", "Edm.Int32", availabilityViewInterval)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSchedule"), ScheduleInformation.class, _parameters);
    }

    @Function(name = "allowedCalendarSharingRoles")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CalendarRoleType> allowedCalendarSharingRoles(String user) {
        Preconditions.checkNotNull(user, "user cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("User", "Edm.String", Checks.checkIsAscii(user))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.allowedCalendarSharingRoles"), CalendarRoleType.class, _parameters);
    }

}
