package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Bitlocker;
import odata.msgraph.client.beta.entity.collection.request.BitlockerRecoveryKeyCollectionRequest;

@JsonIgnoreType
public class BitlockerRequest extends EntityRequest<Bitlocker> {

    public BitlockerRequest(ContextPath contextPath, Optional<Object> value) {
        super(Bitlocker.class, contextPath, value, false);
    }

    public BitlockerRecoveryKeyRequest recoveryKeys(String id) {
        return new BitlockerRecoveryKeyRequest(contextPath.addSegment("recoveryKeys").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BitlockerRecoveryKeyCollectionRequest recoveryKeys() {
        return new BitlockerRecoveryKeyCollectionRequest(
                        contextPath.addSegment("recoveryKeys"), Optional.empty());
    }

}
