package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.BaseTask;
import odata.msgraph.client.beta.entity.collection.request.ChecklistItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LinkedResource_v2CollectionRequest;

@JsonIgnoreType
public class BaseTaskRequest extends EntityRequest<BaseTask> {

    public BaseTaskRequest(ContextPath contextPath, Optional<Object> value) {
        super(BaseTask.class, contextPath, value, false);
    }

    public ChecklistItemRequest checklistItems(String id) {
        return new ChecklistItemRequest(contextPath.addSegment("checklistItems").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ChecklistItemCollectionRequest checklistItems() {
        return new ChecklistItemCollectionRequest(
                        contextPath.addSegment("checklistItems"), Optional.empty());
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.empty());
    }

    public LinkedResource_v2Request linkedResources(String id) {
        return new LinkedResource_v2Request(contextPath.addSegment("linkedResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LinkedResource_v2CollectionRequest linkedResources() {
        return new LinkedResource_v2CollectionRequest(
                        contextPath.addSegment("linkedResources"), Optional.empty());
    }

    public BaseTaskListRequest parentList() {
        return new BaseTaskListRequest(contextPath.addSegment("parentList"), Optional.empty());
    }

    @Action(name = "move")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BaseTask> move(String destinationTaskListId) {
        Preconditions.checkNotNull(destinationTaskListId, "destinationTaskListId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("destinationTaskListId", "Edm.String", Checks.checkIsAscii(destinationTaskListId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BaseTask>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.move"), BaseTask.class, _parameters);
    }

}
