package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.B2cIdentityUserFlow;
import odata.msgraph.client.beta.entity.collection.request.IdentityProviderBaseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityProviderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityUserFlowAttributeAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserFlowLanguageConfigurationCollectionRequest;

@JsonIgnoreType
public class B2cIdentityUserFlowRequest extends EntityRequest<B2cIdentityUserFlow> {

    public B2cIdentityUserFlowRequest(ContextPath contextPath, Optional<Object> value) {
        super(B2cIdentityUserFlow.class, contextPath, value, false);
    }

    public IdentityProviderRequest identityProviders(String id) {
        return new IdentityProviderRequest(contextPath.addSegment("identityProviders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityProviderCollectionRequest identityProviders() {
        return new IdentityProviderCollectionRequest(
                        contextPath.addSegment("identityProviders"), Optional.empty());
    }

    public UserFlowLanguageConfigurationRequest languages(String id) {
        return new UserFlowLanguageConfigurationRequest(contextPath.addSegment("languages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserFlowLanguageConfigurationCollectionRequest languages() {
        return new UserFlowLanguageConfigurationCollectionRequest(
                        contextPath.addSegment("languages"), Optional.empty());
    }

    public IdentityUserFlowAttributeAssignmentRequest userAttributeAssignments(String id) {
        return new IdentityUserFlowAttributeAssignmentRequest(contextPath.addSegment("userAttributeAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityUserFlowAttributeAssignmentCollectionRequest userAttributeAssignments() {
        return new IdentityUserFlowAttributeAssignmentCollectionRequest(
                        contextPath.addSegment("userAttributeAssignments"), Optional.empty());
    }

    public IdentityProviderBaseRequest userFlowIdentityProviders(String id) {
        return new IdentityProviderBaseRequest(contextPath.addSegment("userFlowIdentityProviders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityProviderBaseCollectionRequest userFlowIdentityProviders() {
        return new IdentityProviderBaseCollectionRequest(
                        contextPath.addSegment("userFlowIdentityProviders"), Optional.empty());
    }

}
